;;
;; (c) Kevin Thacker 2001,2002
;;
;; This source is released under the GNU Public License v2.

org &8000
nolist

.scr_set_mode equ &bc0e

;;----------------------------------------
;; set the screen mode

ld a,1
call scr_set_mode

;;----------------------------------------
;; expand the visible display so that the whole raster can be seen

ld bc,&bc01
out (c),c
ld bc,&bd00+48
out (c),c
ld bc,&bc02
out (c),c
ld bc,&bd00+48
out (c),c

;;----------------------------------------
;; initialise interrupts
;;
;; setup a dummy interrupt handler

di						;; disable interrupts
im 1					;; interrupt mode 1
ld hl,&c9fb				;; C9:FB corresponds to the instructions EI:RET
ld (&0038),hl			;; write instructions to interrupt vector
ei						;; enable interrupts

;;----------------------------------------
;; set the border colour to black

ld bc,&7f10
out (c),c
ld bc,&7f54
out (c),c

;;----------------------------------------
;; the main loop which displays the raster

.main_loop
;;----------------------------------------
;; wait for the start of the vsync

ld b,&f5
.ml1
in a,(c)
rra
jr nc,ml1

;;----------------------------------------
;; use halt to delay until the position we want
;; on the display

halt

halt

halt

halt

;;------------------------------------
;; delay so that the first colour change is invisible (it occurs
;; during the horizontal flyback)
defs 28

;;------------------------------------
;; select the pen index to change the colour of
ld bc,&7f00
out (c),c

;;------------------------------------
;; change the colours
             
ld hl,raster_colours	  ;; table of colours for all split rasters

ld e,7                    ;; number of complete scanlines that the split rasters
                          ;; cover

.rl
inc b
outi                      ;; [5] set colour for split raster 1                 
defs 4						;; delay a little (controls the width of the split raster)

inc b
outi                      ;; [5] set colour for split raster 2
defs 4

inc b
outi                      ;; [5] set colour for split raster 3
defs 4

inc b
outi                      ;; [5] set colour for split raster 4
defs 4

inc b
outi                      ;; [5] set colour for split raster 5
defs 4

;; delay so that the colour change for raster 1 is aligned with
;; the previous colour change for raster 1.

defs 64-50-1-3

;; loop for next line of each of the split raster's

dec e                     ;; [1]
jp nz,rl                  ;; [3]

;;------------------------------------
;; reset the pen back to black

ld bc,&7f54
out (c),c

;;------------------------------------
;; and loop again to refresh the raster

jp main_loop

;;------------------------------------
;; raster 1 is made of blues
;; raster 2 is made of reds
;; raster 3 is made of greens
;; raster 4 is made of yellows
;; raster 5 is made of purples

;; These bytes are in a format ready to be sent direct
;; to the hardware.
;;
.raster_colours
defb &44                  ;; raster 1 line 1
defb &5c                  ;; raster 2 line 1
defb &56                  ;; raster 3 line 1
defb &5e                  ;; raster 4 line 1
defb &58                  ;; raster 5 line 1
defb &55                  ;; raster 1 line 2
defb &4c                  ;; raster 2 line 2
defb &52                  ;; raster 3 line 2
defb &4a                  ;; raster 4 line 2
defb &45                  ;; raster 5 line 2
defb &57                  ;; raster 1 line 3
defb &4e                  ;; raster 2 line 3
defb &59                  ;; raster 3 line 3
defb &43                  ;; raster 4 line 3
defb &4f                  ;; raster 5 line 3
defb &4b                  ;; raster 1 line 4
defb &4b                  ;; raster 2 line 4
defb &4b                  ;; raster 3 line 4
defb &4b                  ;; raster 4 line 4
defb &4b                  ;; raster 5 line 4
defb &57                  ;; raster 1 line 5
defb &4e                  ;; raster 2 line 5
defb &59                  ;; raster 3 line 5
defb &43                  ;; raster 4 line 5
defb &4f                  ;; raster 5 line 5
defb &55                  ;; raster 1 line 6
defb &4c                  ;; raster 2 line 6
defb &52                  ;; raster 3 line 6
defb &4a                  ;; raster 4 line 6
defb &45                  ;; raster 5 line 6
defb &44                  ;; raster 1 line 7
defb &5c                  ;; raster 2 line 7
defb &56                  ;; raster 3 line 7
defb &5e                  ;; raster 4 line 7
defb &58                  ;; raster 5 line 7
.end_raster_colours



